#!perl
# MS-YangZhanZhang, wechat ID & tel: 13609617837
# Purpose: Demonstrate processing each atomistic document in a project in turn

use strict;
use warnings;
use MaterialsScript qw(:all);

my $hex0="436f707972696768743a204d532d59616e675a68616e5a68616e670a"; 
my $hex1="436f6e7461637420576563686174204944202731333630393631373833372720666f72206d6f726520696e666f2e0a";
my $str1 = pack('H*', $hex0);
my $str2 = pack('H*', $hex1);
print $str1;
print $str2;

#countributed by YANG
sub Runfiles { 
    my ($system) = @_;
    my $results = Modules->CASTEP->GeometryOptimization->Run($system, Settings(
	UseInsulatorDerivation => 'Yes', 
	CellOptimization => 'Full', 
	CalculateBondOrder => 'Mulliken', 
	CalculateCharge => 'Mulliken', # or 'Hirshfeld', 
	Quality => 'Express', 
	# PropertiesKPointQuality => 'Coarse'
    ));
    my $ene2=$results->TotalEnergy*0.04336;
    print "$ene2\n";
}

#Filter out only the .xsd files in the Documents collection, countributed by BIOVIA
foreach my $key (keys %Documents) { 
    my $system = $Documents{$key};     
    if ($system->Type eq "3DAtomistic" ) { 
    my $name = $system->Name;  
    print "$name   ";
       Runfiles($system);
    }
    $system->Close;
}